<?php

// Code taken from a random opensource project on github
// https://github.com/filp/whoops/blob/master/src/Whoops/Run.php

class Code {

	/**
	 * Handles an exception, ultimately generating a Whoops error
	 * page.
	 *
	 * @param Exception $exception
	 */
	public function handleException(Exception $exception) {
		// Walk the registered handlers in the reverse order
		// they were registered, and pass off the exception
		$inspector = $this->getInspector($exception);

		for ($i = count($this->handlerStack) - 1; $i >= 0; $i--) {
			$handler = $this->initHandler($this->handlerStack[$i]);
			$handlerResponse = $handler->handle($exception);

			$this->handleResponse($handlerResponse);
		}
	}

	private function initHandler($handler) {
		$handler->setRun($this);
		$handler->setInspector($inspector);
		$handler->setException($exception);
		return $handler;
	}

	private function handleResponse($handlerResponse) {
		if ($handlerResponse === Handler::LAST_HANDLER)
			break;
		if ($handlerResponse === Handler::QUIT) {
			if ($this->allowQuit())
				exit;
			break;
		}
	}

}
